package gov.va.med.term.vhat.propertyTypes;

import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.BPT_Annotations;
import gov.va.oia.terminology.converters.sharedUtils.propertyTypes.Property;
import gov.vha.isaac.MetaData;
import gov.vha.isaac.ochre.api.component.concept.ConceptSpecification;

public class PT_Annotations extends BPT_Annotations
{
	public enum Attribute
	{
		VUID(MetaData.VUID, true),
		CODE(MetaData.CODE, true);

		private Property property;

		private Attribute(String niceName)
		{
			// Don't know the owner yet - will be autofilled when we add this to the parent, below.
			property = new Property(null, niceName);
		}
		
		private Attribute(ConceptSpecification cs, boolean isIdentifier)
		{
			// Don't know the owner yet - will be autofilled when we add this to the parent, below.
			property = new Property(null, cs, isIdentifier);
		}

		public Property getProperty()
		{
			return property;
		}
	}

	public PT_Annotations()
	{
		super("VHAT");
		for (Attribute attr : Attribute.values())
		{
			addProperty(attr.getProperty());
		}
	}
}
